<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Vente extends Model 
{

    protected $table = 'ventes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('montant_total', 'nbre_articles', 'id_client', 'reduction', 'tva', 'prix_ttc', 'devise', 'moyen_de_payement', 'source_vente');
    protected $visible = array('montant_total', 'nbre_articles', 'id_client', 'reduction', 'tva', 'prix_ttc', 'devise', 'moyen_de_payement', 'source_vente');

    public function client()
    {
        return $this->belongsTo('App\Models\Client', 'id_client');
    }

    public function lignes_vente()
    {
        return $this->hasMany('App\Models\Ligne_vente', 'id_vente');
    }

}